﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using DataAccess;
using MDWSLib.MDWSEmrSvc;

public partial class TBICDSX : System.Web.UI.Page
{
    /// <summary>
    /// US:5716 
    /// logs in and looks up the patient. used by the thin cleint to 
    /// access the website.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        Session["PING_MDWS"] = "1";

        //gather params and try to login
        string strDUZ = string.Empty;
        string strRegionID = string.Empty;
        string strSiteID = string.Empty;
        string strUN = string.Empty;
        string strP = string.Empty;
        string strDFN = string.Empty;

        //duz from form post
        if (Request.Form["pTBICDS1"] != null)
        {
            strDUZ = Request.Form["pTBICDS1"].ToString();
        }
        //region id from form post
        if (Request.Form["pTBICDS2"] != null)
        {
            strRegionID = Request.Form["pTBICDS2"].ToString();
        }
        //site id from form post
        if (Request.Form["pTBICDS3"] != null)
        {
            strSiteID = Request.Form["pTBICDS3"].ToString();
        }
        //user n from from post
        if (Request.Form["pTBICDS4"] != null)
        {
            strUN = Request.Form["pTBICDS4"].ToString();
        }
        //user p from from post
        if (Request.Form["pTBICDS5"] != null)
        {
            strP = Request.Form["pTBICDS5"].ToString();
        }
        //dfn from form post used to lookup the patient
        if (Request.Form["pTBICDS6"] != null)
        {
            strDFN = Request.Form["pTBICDS6"].ToString();
        }

        //logging in so clear the initiated session, these vars already existed
        Session["SESSION_INITIATED"] = null;
        Session["REGION_ID"] = null;
        Session["SITE_ID"] = null;
        
        //dont need to keep this at session state, it keeps itself open
        //we jsut make a new instance for each call
        //Session["EmrSvcSoapClient"] = null;

        //check region and site
        if (string.IsNullOrEmpty(strRegionID))
        {
            Session["PING_MDWS"] = null;
        
            Master.LogOff();
            return;
        }
        if (string.IsNullOrEmpty(strSiteID))
        {
            Session["PING_MDWS"] = null;
        
            Master.LogOff();
            return;
        }

        //get region and site for logging in to mdws
        long lRegionID = CDataUtils2.ToLong(strRegionID);
        long lSiteID = CDataUtils2.ToLong(strSiteID);
                
        //login to mdws
        EmrSvcSoapClient mdwsSOAPClient = null;
        long lFXUserID = -1;
        CMDWSOps ops = new CMDWSOps(Master.GetDataObject());
        CStatus status = ops.MDWSLogin(strUN,
                                       strP,
                                       lRegionID,
                                       lSiteID,
                                       Master.MDWSEmrSvcContext,
                                       out strDUZ,
                                       out lFXUserID,
                                       out mdwsSOAPClient);

        //successful login
        if (status.Status && lFXUserID > 0)
        {
            //create a new database session from the user
            CSec sec = new CSec();
            if (!sec.CreateSession(Master, lFXUserID))
            {
                Session["PING_MDWS"] = null;
        
                Master.LogOff();
                return;
            }

            //only set here once after successful login
            //dont need to keep this at session state, it keeps itself open
            //we just make a new instance for each call
            //Session["EmrSvcSoapClient"] = mdwsSOAPClient;

            //set a session variable with the login time
            Session["SESSION_INITIATED"] = DateTime.Now;

            //keep the region and site id 
            Session["REGION_ID"] = Convert.ToString(lRegionID);
            Session["SITE_ID"] = Convert.ToString(lSiteID);

            //keep the fx_user_id in the db for this session
            Master.SetSessionValue("FX_USER_ID", Convert.ToString(lFXUserID));
            Master.FXUserID = lFXUserID;

            //cache the duz and dfn
            Master.DUZ = strDUZ;
            Master.DFN = strDFN;

            Session["PING_MDWS"] = null;

            //lookup the patient by DFN from MDWS and transfer to the central db
            //will redirect home if the lookup fails, user can then try to look the 
            //patient up manually. 
            Master.LookupPatientByDUZ(strDUZ, strDFN);
            return;
        }
        else
        {
            Session["PING_MDWS"] = null;
        
            Session["SESSION_INITIATED"] = null;
            Master.LogOff();
        }

        Session["PING_MDWS"] = null;
        
    }

}